<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class SMEGA_MENU_CodeAutoUpdate {
	// URL to check for updates, this is where the index.php script goes.
	public $api_url;  //phpcs:ignore
	private $slug;  //phpcs:ignore
	public $plugin;  //phpcs:ignore
	private $api_version;  //phpcs:ignore

	/**
	 * Constructor funtion.
	 *
	 * @param string $api_url API.
	 * @param string $slug Slug.
	 * @param string $plugin Plugin.
	 */
	public function __construct( $api_url, $slug, $plugin ) {
		$this->api_url = $api_url;
		$this->slug    = $slug;
		$this->plugin  = $plugin;

		// use latest available API.
		$this->api_version = 1.1;

	}

	public function check_for_plugin_update( $checked_data ) {
		if ( ! is_object( $checked_data ) || ! isset( $checked_data->response ) ) {
			return $checked_data;
		}

		$request_string = $this->prepare_request( 'plugin_update' );
		if ( false === $request_string ) {
			return $checked_data;
		}

		global $wp_version;

		// Start checking for an update.
		$request_uri = $this->api_url . '?' . http_build_query( $request_string, '', '&' );

		// check if cached.
		$data = get_site_transient( 'supreme-mega-menu-check_for_plugin_update_' . md5( $request_uri ) );
		if ( false === $data ) {
			$data = wp_remote_get(
				$request_uri,
				array(
					'timeout'    => 20,
					'user-agent' => 'WordPress/' . $wp_version . '; SupremeMapsPro/' . SMEGA_MENU_VERSION . '; ' . SMEGA_MENU_INSTANCE,
				)
			);

			if ( is_wp_error( $data ) || 200 !== $data['response']['code'] ) {
				return $checked_data;
			}

			set_site_transient( 'supreme-mega-menu-check_for_plugin_update_' . md5( $request_uri ), $data, 60 * 60 * 4 );

		}

		$response_block = json_decode( $data['body'] );

		if ( ! is_array( $response_block ) || count( $response_block ) < 1 ) {
			return $checked_data;
		}

		// retrieve the last message within the $response_block.
		$response_block = $response_block[ count( $response_block ) - 1 ];
		$response       = isset( $response_block->message ) ? $response_block->message : '';

		if ( is_object( $response ) && ! empty( $response ) ) {
			$response = $this->postprocess_response( $response );

			$checked_data->response[ $this->plugin ] = $response;
		}

		return $checked_data;
	}

	public function plugins_api_call( $def, $action, $args ) {
		if ( ! is_object( $args ) || ! isset( $args->slug ) || $args->slug !== $this->slug ) {
			return $def;
		}

		$request_string = $this->prepare_request( $action, $args );
		if ( false === $request_string ) {
			return new WP_Error( 'plugins_api_failed', __( 'An error occour when try to identify the pluguin.', 'supreme-maps' ) . '&lt;/p> &lt;p>&lt;a href=&quot;?&quot; onclick=&quot;document.location.reload(); return false;&quot;>' . __( 'Try again', 'woo-global-cart' ) . '&lt;/a>' );
		}

			global $wp_version;

			$request_uri = $this->api_url . '?' . http_build_query( $request_string, '', '&' );
			$data        = wp_remote_get(
				$request_uri,
				array(
					'timeout'    => 20,
					'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo( 'url' ),
				)
			);

		if ( is_wp_error( $data ) || 200 !== $data['response']['code'] ) {
			return new WP_Error( 'plugins_api_failed', __( 'An Unexpected HTTP Error occurred during the API request.', 'supreme-maps' ) . '&lt;/p> &lt;p>&lt;a href=&quot;?&quot; onclick=&quot;document.location.reload(); return false;&quot;>' . __( 'Try again', 'woo-global-cart' ) . '&lt;/a>', $data->get_error_message() );
		}

		$response_block = json_decode( $data['body'] );
		// retrieve the last message within the $response_block.
		$response_block = $response_block[ count( $response_block ) - 1 ];
		$response       = $response_block->message;

		if ( is_object( $response ) && ! empty( $response ) ) {
				$response = $this->postprocess_response( $response );

				return $response;
		}
	}

	public function prepare_request( $action, $args = array() ) {
		global $wp_version;

		$license_data = get_site_option( 'smega_menu_license_key' );

		$license_data_key;
		if ( ! isset( $license_data['key'] ) ) {
			$license_data_key = '';
		} else {
			$license_data_key = $license_data['key'];
		}

		return array(
			'woo_sl_action'     => $action,
			'version'           => SMEGA_MENU_VERSION,
			'product_unique_id' => SMEGA_MENU_PRODUCT_ID,
			'licence_key'       => $license_data_key,
			'domain'            => SMEGA_MENU_INSTANCE,
			'wp-version'        => $wp_version,

			'api_version'       => $this->api_version,
		);
	}

	private function postprocess_response( $response ) {
		// include slug and plugin data.
		$response->slug   = $this->slug;
		$response->plugin = $this->plugin;

		// if sections are being set.
		if ( isset( $response->sections ) ) {
			$response->sections = (array) $response->sections;
		}

		// if banners are being set.
		if ( isset( $response->banners ) ) {
			$response->banners = (array) $response->banners;
		}

		// if icons being set, convert to array.
		if ( isset( $response->icons ) ) {
			$response->icons = (array) $response->icons;
		}

		return $response;

	}
}

function SMEGA_MENU_run_updater() {

	$wp_plugin_auto_update = new SMEGA_MENU_CodeAutoUpdate( SMEGA_MENU_APP_API_URL, 'supreme-mega-menu', 'supreme-mega-menu/supreme-mega-menu.php' );

	// Take over the update check.

	add_filter(
		'pre_set_site_transient_update_plugins',
		array(
			$wp_plugin_auto_update,
			'check_for_plugin_update',
		)
	);

	// Take over the Plugin info screen.

	add_filter(
		'plugins_api',
		array(
			$wp_plugin_auto_update,
			'plugins_api_call',
		),
		10,
		3
	);
}

add_action( 'after_setup_theme', 'SMEGA_MENU_run_updater' );
