/**
 * GDPR object.
 */
var wacuGDPR = {
	isEnable: function() {
		return ( 'yes' === wacuObj.is_gdpr ) ? true : false;
	},
	isChecked: function() {
		if ( true === jQuery( ".wacu-gdpr-wrapper input" ).is( ":not(:checked)" ) ) {
			return false;
		} else {
			return true;
		}
	},
	showError() {
		jQuery( ".wacu-gdpr-wrapper" ).addClass( "wacu-gdpr-wrapper--error" );
		jQuery( "[data-wacu-main-popup]" ).click();

		setTimeout( function() {
			jQuery( ".wacu-gdpr-wrapper" ).removeClass( "wacu-gdpr-wrapper--error" );
		}, 2000 );
	}
}

;( function( $ ) {
	"use strict";

	var wacuLoader = '<div class="wacu-spinner">' +
		'<div class="double-bounce1 wacu-bg-color"></div>' +
		'<div class="double-bounce2 wacu-bg-color"></div>' +
	'</div>';

	$( document ).ready( function() {

		const wpAjaxURL         = wacuObj.ajax_url;
		const mainPopup         = $( '.wacu-popup' );
		const subPopup          = $( '.wacu-sub-popup' );
		const smartPopup        = $( '.wacu-smart-popup' );
		const trigger           = $( '.wacu-trigger' );
		const typingIndicator   = $( '.wacu-typing-indicator' );

		function getUnixTime() {
			return Math.round( ( new Date() ).getTime() / 1000 );
		}

		// Popup trigger
		$( '[data-wacu-popup-trigger]' ).on( 'click', function() {
			if ( '0' == mainPopup.attr( 'data-wacu-main-popup-status' ) ) {
				// Code for display popup
				mainPopup.show();

				typingIndicator.hide();
				smartPopup.hide();
				mainPopup.attr( 'data-wacu-main-popup-status', 1 );
				trigger
					.removeClass( 'wacu-trigger--close' )
					.addClass( 'wacu-trigger--open' )
					.css( {
						'transform':'scale(0.9)',
					} );

				//  Popup open trigger.
				$( document.body ).trigger( 'wacu_popup_open' );
			} else {
				// Code for hide popup
				mainPopup.hide();
				smartPopup.hide();
				subPopup.hide();
				mainPopup.attr( 'data-wacu-main-popup-status', 0 );
				trigger
					.removeClass( 'wacu-trigger--open' )
					.addClass( 'wacu-trigger--close' )
					.css( {
						'transform':'scale(1)',
					} );

				//  Popup close trigger.
				$( document.body ).trigger( 'wacu_popup_close' );
			}
		} );

		// Sub popup trigger
		$( '[data-wacu-sub-popup-trigger]' ).on( 'click', function() {
			var subPopupID = $( this ).data('wacu-sub-popup-trigger');

			$( '[data-wacu-sub-popup="' + subPopupID + '"]' ).show();
			mainPopup.hide();

			// Sub popup close trigger.
			$( document.body ).trigger( 'wacu_sub_popup_open' );
		} );

		// Back to main popup
		$( '[data-wacu-main-popup]' ).on( 'click', function() {
			mainPopup.show();
			subPopup.hide();

			// Sub popup close trigger.
			$( document.body ).trigger( 'wacu_sub_popup_close' );
		} );

		// Close smart popup
		$( '[data-wacu-smart-popup-close]' ).on( 'click', function() {
			smartPopup.hide();
			localStorage.wacuSmartMessageInterval = getUnixTime() + Number( wacuObj.smart_popup_interval );
		} );

		// Trigger ripple effect.
		if ( 'ripple' === wacuObj.trigger_effect && 'icon_only' === wacuObj.trigger_type ) {
			if ( 'off' !== sessionStorage.wacuTriggerEffect ) {
				$( '.wacu-trigger' ).addClass( 'wacu-trigger--ripple' );
			}

			$( document.body ).on( 'wacu_popup_open', function() {
				$( '.wacu-trigger' ).removeClass( 'wacu-trigger--ripple' );
				sessionStorage.wacuTriggerEffect = 'off';
			} );
		}

		// Auto display smart popup
		setTimeout( function() {
			if ( 'yes' != wacuObj.smart_popup_status ) {
				return;
			}
			if ( '1' == mainPopup.attr( 'data-wacu-main-popup-status' ) ) {
				return;
			}
			if ( localStorage.wacuSmartMessageInterval <= getUnixTime() ) {
				localStorage.removeItem( 'wacuSmartMessageInterval' );
			}
			if ( localStorage.wacuSmartMessageInterval ) {
				return;
			}

			var smartMessageTypingTime   = Number( wacuObj.smart_popup_typing_time );
			var smartMessageTypingTimeI  = Number( wacuObj.smart_popup_typing_time );
			var smartMessageMessageTime  = Number( wacuObj.smart_popup_message_time );
			var smartMessageTyping       = $( '.wacu-smart-popup-messages .wacu-typing' );
			var smartMessages            = $( '.wacu-smart-popup-message_item' );
			var smartMessagesLength      = $( '.wacu-smart-popup-message_item' ).length;

			$( '.wacu-smart-popup-message_item' ).each( function( i, e ) {
				setTimeout(
					function() {
						smartMessageTyping.hide();
						$( e ).show();
					},
					Number( smartMessageTypingTimeI ) * 1000,
				);

				if ( smartMessagesLength == ( i + 1 ) ) {
					return false;
				}
				setTimeout(
					function() {
						smartMessages.hide();
						smartMessageTyping.show();
					},
					Number( smartMessageMessageTime + smartMessageTypingTimeI ) * 1000
				);

				smartMessageTypingTimeI = smartMessageTypingTimeI + ( smartMessageMessageTime + smartMessageTypingTime );
			} );

			typingIndicator.hide();
			smartPopup.show();
			localStorage.wacuSmartMessageInterval = getUnixTime() + Number( wacuObj.smart_popup_interval );
		}, Number( wacuObj.smart_popup_delay ) * 1000 );

		// Schedule call
		$( '.wacu-schedule-call-form' ).on( 'submit', function( e ) {
			e.preventDefault();

			var error    = false;
			var postData = $( this ).serialize();

			const scheduleForm      = $( '.wacu-schedule-call-form' );
			const scheduleLoader    = $( '.wacu-schedule-call-loader' );
			const scheduleResponse  = $( '.wacu-schedule-call-response' );

			$( '[data-wacu-schedule-call-required]' ).each( function( i, e ) {
				$( this ).removeClass( 'wacu-schedule-call-required' );

				if ( '' === $( this ).val() ) {
					$( this ).addClass( 'wacu-schedule-call-required' );
					error = true;
				}
			} );

			if ( wacuObj.is_schedule_call_grecaptcha ) {
				if ( '' === grecaptcha.getResponse() ) {
					$( '#wacu-grecaptcha-v2-schedule-call' ).addClass( 'wacu-schedule-call-required' );
					error = true;
				} else {
					$( '#wacu-grecaptcha-v2-schedule-call' ).removeClass( 'wacu-schedule-call-required' );
				}
			}

			// If any required field is not filled.
			if ( error ) {
				return;
			}

			scheduleForm.hide();
			scheduleLoader.show();

			$.ajax( {
				url: wpAjaxURL,
				type: 'post',
				dataType: 'json',
				data: 'action=wacu_schedule_call_submit&' + postData,
				success: function( response ) {
					if ( 1 == response.status ) {
						scheduleLoader.hide();
						scheduleResponse.show();
						scheduleResponse.html( response.message );
					}
				}
			} );

			$( document.body ).on( 'wacu_sub_popup_close', function() {
				scheduleForm.show();
				scheduleResponse.hide();
			} );

		} );

		// Email Us
		$( '.wacu-email-us-form' ).on( 'submit', function( e ) {
			e.preventDefault();

			var error    = false;
			var postData = $( this ).serialize();

			const emailUsForm       = $( '.wacu-email-us-form' );
			const emailUsLoader     = $( '.wacu-email-us-loader' );
			const emailUsResponse   = $( '.wacu-email-us-response' );

			$( '[data-wacu-email-us-required]' ).each( function( i, e ) {
				$( this ).removeClass( 'wacu-email-us-required' );

				if ( '' === $( this ).val() ) {
					$( this ).addClass( 'wacu-email-us-required' );
					error = true;
				}
			} );

			if ( wacuObj.is_email_us_grecaptcha ) {
				if ( '' === grecaptcha.getResponse() ) {
					$( '#wacu-grecaptcha-v2-email-us' ).addClass( 'wacu-email-us-required' );
					error = true;
				} else {
					$( '#wacu-grecaptcha-v2-email-us' ).removeClass( 'wacu-email-us-required' );
				}
			}

			// If any required field is not filled.
			if ( error ) {
				return;
			}

			emailUsForm.hide();
			emailUsLoader.show();

			$.ajax( {
				url: wpAjaxURL,
				type: 'post',
				dataType: 'json',
				data: 'action=wacu_email_us_submit&' + postData,
				success: function( response ) {
					if ( 1 == response.status ) {
						emailUsLoader.hide();
						emailUsResponse.show();
						emailUsResponse.html( response.message );
					}
				}
			} );

			$( document.body ).on( 'wacu_sub_popup_close, wacu_popup_close', function() {
				emailUsForm.show();
				emailUsResponse.hide();
			} );

		} );

		/**
		 * GDPR
		 */
		$( document ).ready( function() {
			$( ".wacu-social-contact" ).on( "click touch", function( e ) {
				if ( ! wacuGDPR.isChecked() ) {
					e.preventDefault();
					wacuGDPR.showError();
				}
			} );
		} );

		/**
		 * Integrations
		 */
		$( document ).on( "click", "[data-wacu-integration-trigger]", function() {
			var integration = $( this ).data( 'wacu-integration-trigger' );
			if ( wacuGDPR.isEnable() ) {
				if ( ! wacuGDPR.isChecked() ) {
					return;
				}
			}

			// Facebook Customer Chat Integration.
			if ( 'facebook_customer_chat' === integration ) {
				FB.CustomerChat.show();
				FB.CustomerChat.showDialog();
				$( ".wacu-widget" ).hide();
				$( "#wacu-fcc" ).removeClass( "wacu-hide" );
			}
		} );

		window.fbAsyncInit = function() {
			FB.Event.subscribe( "customerchat.dialogHide", function() {
				$( ".wacu-widget" ).show();
				$( "#wacu-fcc" ).addClass( "wacu-hide" );
			});
		}

		/**
		 * Trigger button animation.
		 *
		 * @since 1.1.8
		 */
		jQuery.fn.nextOrFirst = function( selector ) {
			var next = this.next( selector );
			return ( next.length ) ? next : this.prevAll( selector ).last();
		};

		function triggerAnimation() {
			var activeSlide = jQuery( ".wacu-trigger-animate.active" );

			activeSlide
				.removeClass( "active" )
				.nextOrFirst()
				.addClass( "active" );
		}

		var triggerAnimationInterval = setInterval( triggerAnimation, 800 );

		// Pause animation on mouse enter.
		jQuery( '.wacu-trigger' ).on( 'mouseenter', function() {
			clearInterval( triggerAnimationInterval );
		} );

		// Play animation on mouse leave.
		jQuery( '.wacu-trigger' ).on( 'mouseleave', function() {
			triggerAnimationInterval = setInterval( triggerAnimation, 800 );
		} );

	} ); // End documnet ready.

} )( jQuery )
