<?php
defined( 'ABSPATH' ) || exit;

class WACU_Admin_Init {

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
	}

	/**
	 * Add admin menu.
	 */
	public function add_admin_menu() {
		add_menu_page(
			esc_html__( 'WP Any Contact Us', 'wp-any-contact-us' ),
			esc_html__( 'WP Any Contact Us', 'wp-any-contact-us' ),
			'manage_options',
			'wp-any-contact-us',
			array( $this, 'admin_settings_page' ),
			'dashicons-phone'
		);
		add_submenu_page(
			'wp-any-contact-us',
			esc_html__( 'Social Contacts', 'wp-any-contact-us' ),
			esc_html__( 'Social Contacts', 'wp-any-contact-us' ),
			'manage_options',
			'wp-any-contact-us_social-contacts',
			array( $this, 'social_contacts_page' )
		);
		add_submenu_page(
			'wp-any-contact-us',
			esc_html__( 'Smart Messages', 'wp-any-contact-us' ),
			esc_html__( 'Smart Messages', 'wp-any-contact-us' ),
			'manage_options',
			'wp-any-contact-us_smart-messages',
			array( $this, 'smart_messages_page' )
		);
		add_submenu_page(
			'wp-any-contact-us',
			esc_html__( 'GDPR Setting', 'wp-any-contact-us' ),
			esc_html__( 'GDPR Setting', 'wp-any-contact-us' ),
			'manage_options',
			'wp-any-contact-us_gdpr',
			array( $this, 'gdpr_setting_page' )
		);
		add_submenu_page(
			'wp-any-contact-us',
			esc_html__( 'Plugin Support', 'wp-any-contact-us' ),
			esc_html__( 'Plugin Support', 'wp-any-contact-us' ),
			'manage_options',
			'wp-any-contact-us_plugin-support',
			array( $this, 'plugin_support_page' )
		);
		add_submenu_page(
			'wp-any-contact-us',
			esc_html__( 'Documentation', 'wp-any-contact-us' ),
			esc_html__( 'Documentation', 'wp-any-contact-us' ),
			'manage_options',
			'wp-any-contact-us_documentation',
			array( $this, 'plugin_documentation_page' )
		);
		add_submenu_page(
			'wp-any-contact-us',
			null,
			null,
			'manage_options',
			'wp-any-contact-us_shortcode',
			array( $this, 'shortcode_page' )
		);
		add_submenu_page(
			'wp-any-contact-us',
			null,
			null,
			'manage_options',
			'wp-any-contact-us_grecaptcha',
			array( $this, 'grecaptcha_page' )
		);
	}

	public function admin_settings_page() {
	   require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-settings-page.php';
	}

	public function social_contacts_page() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-social-contacts-page.php';
	}

	public function smart_messages_page() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-smart-messages-page.php';
	}

	public function gdpr_setting_page() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-gdpr-setting-page.php';
	}

	public function shortcode_page() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-shortcode-page.php';
	}

	public function plugin_support_page() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-plugin-support-page.php';
	}

	public function grecaptcha_page() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-grecaptcha-page.php';
	}

	public function plugin_documentation_page() {
		require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-plugin-documentation-page.php';
	}

}

new WACU_Admin_Init;
