<form action="#" method="post" class="wacu-admin-form">
	<?php wp_nonce_field( 'wacu_edit_social_contact_submit', 'wacu_edit_social_contact_security' ); ?>
	<input type="hidden" name="wacu_social_contact[id]" value="<?php echo absint( $id ); ?>">
	<div class="wacu-row">
		<div class="wacu-col-50">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Title', 'wp-any-contact-us' ); ?></label>
				<input type="text" name="wacu_social_contact[title]" value="<?php echo esc_attr( $social_contact['title'] ); ?>">
			</div>
		</div>
		<div class="wacu-col-50">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Description', 'wp-any-contact-us' ); ?></label>
				<input type="text" name="wacu_social_contact[description]" value="<?php echo esc_attr( $social_contact['description'] ); ?>">
			</div>
		</div>
	</div>
	<div class="wacu-row">
		<div class="wacu-col-50">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Select Icon or Enter HTML', 'wp-any-contact-us' ); ?></label>
				<?php
					echo WACU_Icon::selector(
						array(
							'selected' => esc_attr( $social_contact['icon'] ),
							'name'     => 'wacu_social_contact[icon]',
						)
					);
				?>
			</div>
		</div>
		<div class="wacu-col-50">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Icon Color', 'wp-any-contact-us' ); ?></label>
				<input type="text" class="wacu-color-picker" name="wacu_social_contact[icon_color]" value="<?php echo esc_attr( $social_contact['icon_color'] ); ?>">
			</div>
		</div>
	</div>
	<div class="wacu-row">
		<div class="wacu-col-50">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Display On', 'wp-any-contact-us' ); ?></label>
				<select name="wacu_social_contact[device]">
					<option value="0" <?php selected( '0', $social_contact['device'], true ); ?>><?php esc_html_e( 'Off', 'wp-any-contact-us' ); ?></option>
					<option value="1" <?php selected( '1', $social_contact['device'], true ); ?>><?php esc_html_e( 'Mobile', 'wp-any-contact-us' ); ?></option>
					<option value="2" <?php selected( '2', $social_contact['device'], true ); ?>><?php esc_html_e( 'Desktop', 'wp-any-contact-us' ); ?></option>
					<option value="3" <?php selected( '3', $social_contact['device'], true ); ?>><?php esc_html_e( 'All Devices', 'wp-any-contact-us' ); ?></option>
				</select>
			</div>
		</div>
		<div class="wacu-col-50">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Display By', 'wp-any-contact-us' ); ?></label>
				<select name="wacu_social_contact[register_only]">
					<option value="0" <?php selected( '0', $social_contact['register_only'], true ); ?>><?php esc_html_e( 'All Users', 'wp-any-contact-us' ); ?></option>
					<option value="1" <?php selected( '1', $social_contact['register_only'], true ); ?>><?php esc_html_e( 'Register Users', 'wp-any-contact-us' ); ?></option>
				</select>
			</div>
		</div>
	</div>
	<div class="wacu-row">
		<div class="wacu-col-100">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Type', 'wp-any-contact-us' ); ?></label>
				<select name="wacu_social_contact[type]">
					<option value="1" <?php selected( '1', $social_contact['type'], true ); ?>><?php esc_html_e( 'Link', 'wp-any-contact-us' ); ?></option>
					<option value="2" <?php selected( '2', $social_contact['type'], true ); ?>><?php esc_html_e( 'HTML/Shortcode', 'wp-any-contact-us' ); ?></option>
					<option value="3" <?php selected( '3', $social_contact['type'], true ); ?>><?php esc_html_e( 'Integration', 'wp-any-contact-us' ); ?></option>
				</select>
			</div>
		</div>
	</div>
	<div class="wacu-row">
		<div class="wacu-col-100">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Link', 'wp-any-contact-us' ); ?></label>
				<input type="text" name="wacu_social_contact[link]" value="<?php echo wp_kses_post( $social_contact['link'] ); ?>">
			</div>
		</div>
	</div>
	<div class="wacu-row">
		<div class="wacu-col-100">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Link Target', 'wp-any-contact-us' ); ?></label>
				<select name="wacu_social_contact[target]">
					<option value="_blank" <?php selected( '_blank', $social_contact['target'], true ); ?>><?php esc_html_e( 'New Window', 'wp-any-contact-us' ); ?></option>
					<option value="_self" <?php selected( '_self', $social_contact['target'], true ); ?>><?php esc_html_e( 'Same Window', 'wp-any-contact-us' ); ?></option>
				</select>
			</div>
		</div>
	</div>
	<div class="wacu-row">
		<div class="wacu-col-100">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Integration', 'wp-any-contact-us' ); ?></label>
				<select name="wacu_social_contact[integration]">
					<option value="0"></option>
					<option value="facebook_customer_chat" <?php selected( 'facebook_customer_chat', $social_contact['integration'], true ); ?>><?php esc_html_e( 'Facebook Customer Chat', 'wp-any-contact-us' ); ?></option>
					<option value="tawk_to" <?php selected( 'tawk_to', $social_contact['integration'], true ); ?>><?php esc_html_e( 'Tawk.to', 'wp-any-contact-us' ); ?></option>
					<option value="wordpress_whatsapp_support" <?php selected( 'wordpress_whatsapp_support', $social_contact['integration'], true ); ?>><?php esc_html_e( 'WordPress WhatsApp Support', 'wp-any-contact-us' ); ?></option>
				</select>
			</div>
		</div>
	</div>
	<div class="wacu-row">
		<div class="wacu-col-100">
			<div class="wacu-admin-form__field">
				<label for=""><?php esc_html_e( 'Content', 'wp-any-contact-us' ); ?></label>
				<textarea name="wacu_social_contact[content]"><?php echo wp_kses_post( $social_contact['content'] ); ?></textarea>
			</div>
		</div>
	</div>
	<div class="wacu-modal-footer">
		<a href="#" class="button wacu-modal-close"><?php esc_attr_e( 'Cancel', 'wp-any-contact-us' ); ?></a>
		<input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', 'wp-any-contact-us' ); ?>">
	</div>
</form>
