<?php settings_fields( 'wacu_appearance_settings_option_group' ); ?>
<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Background Color', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<input type="text" class="wacu-color-picker" name="wacu_appearance_settings[background_color]" value="<?php echo esc_attr( wacu_appearance_option( 'background_color' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Default %s', 'wp-any-contact-us' ), '<code>#24303f</code>' );?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Text Color', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<input type="text" class="wacu-color-picker" name="wacu_appearance_settings[text_color]" value="<?php echo esc_attr( wacu_appearance_option( 'text_color' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Default %s', 'wp-any-contact-us' ), '<code>#ffffff</code>' );?></p>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Widget Location', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<select name="wacu_appearance_settings[widget_location]">
					<option value="br" <?php selected( 'br', wacu_appearance_option( 'widget_location' ), true );?>><?php esc_html_e( 'Bottom Right', 'wp-any-contact-us' );?></option>
					<option value="bl" <?php selected( 'bl', wacu_appearance_option( 'widget_location' ), true );?>><?php esc_html_e( 'Bottom Left', 'wp-any-contact-us' );?></option>
				</select>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Trigger Type', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<select name="wacu_appearance_settings[trigger_type]">
					<option value="icon_only" <?php selected( 'icon_only', wacu_appearance_option( 'trigger_type' ), true );?> ><?php esc_html_e( 'Icon only', 'wp-any-contact-us' );?></option>
					<option value="icon_with_text" <?php selected( 'icon_with_text', wacu_appearance_option( 'trigger_type' ), true );?> ><?php esc_html_e( 'Icon with text', 'wp-any-contact-us' );?></option>
				</select>
				<p class="description"><?php esc_html_e( 'You can choose the trigger butto type.', 'wp-any-contact-us' ) ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_appearance_settings[trigger_text]">
					<?php esc_html_e( 'Trigger Text', 'wp-any-contact-us' );?>
				</label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_appearance_settings[trigger_text]"
					class="regular-text"
					name="wacu_appearance_settings[trigger_text]"
					value="<?php echo esc_attr( wacu_appearance_option( 'trigger_text' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Trigger Size', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<input type="number" name="wacu_appearance_settings[trigger_size]" value="<?php echo esc_attr( wacu_appearance_option( 'trigger_size' ) ); ?>" min="20" max="200" step="1">
				<p class="description"><?php printf( esc_html__( 'In pixels only, Default %s', 'wp-any-contact-us' ), '<code>60</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Trigger Icon Size', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<input type="number" name="wacu_appearance_settings[trigger_icon_size]" value="<?php echo esc_attr( wacu_appearance_option( 'trigger_icon_size' ) ); ?>" min="20" max="200" step="1">
				<p class="description"><?php printf( esc_html__( 'In pixels only, Default %s', 'wp-any-contact-us' ), '<code>32</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Trigger Offset', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<input type="number" class="small-text" name="wacu_appearance_settings[trigger_offset_x]" value="<?php echo esc_attr( wacu_appearance_option( 'trigger_offset_x' ) ); ?>" min="0" step="1">
				<input type="number" class="small-text" name="wacu_appearance_settings[trigger_offset_y]" value="<?php echo esc_attr( wacu_appearance_option( 'trigger_offset_y' ) ); ?>" min="0" step="1">
				<p class="description"><?php printf( esc_html__( 'Horizontal and vertical respectively, Default %s for both', 'wp-any-contact-us' ), '<code>16</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Trigger Icon', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<?php
					echo WACU_Icon::selector(
						array(
							'selected' => wacu_appearance_option( 'trigger_icon' ),
							'name'     => 'wacu_appearance_settings[trigger_icon]',
							'class'    => 'regular-text',
						)
					);
				?>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_appearance_settings[trigger_effect]"><?php esc_html_e( 'Trigger Effect', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<select name="wacu_appearance_settings[trigger_effect]" id="wacu_appearance_settings[trigger_effect]">
					<option value="off" <?php selected( 'off', wacu_appearance_option( 'trigger_effect' ) ); ?>><?php esc_html_e( 'Off', 'wp-any-contact-us' ) ?></option>
					<option value="ripple" <?php selected( 'ripple', wacu_appearance_option( 'trigger_effect' ) ); ?>><?php esc_html_e( 'On', 'wp-any-contact-us' ) ?></option>
				</select>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_appearance_settings[trigger_animation]"><?php esc_html_e( 'Trigger Animation', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<label>
					<input type="checkbox" name="wacu_appearance_settings[trigger_animation]" <?php checked( 'yes', wacu_appearance_option( 'trigger_animation' ) ); ?> > <?php esc_html_e( 'Enable/ Disable', 'wp-any-contact-us' ); ?>
					<p class="description"><?php esc_html_e( 'Enable/ disable trigger icons change animation.', 'wp-any-contact-us' ); ?></p>
				</label>
			</td>
		</tr>
	</tbody>
</table>
<?php submit_button();?>
