<?php settings_fields( 'wacu_integrations_settings_option_group' ); ?>
<h3><?php esc_html_e( 'Facebook Customer Chat', 'wp-any-contact-us' ); ?></h3>
<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for="wacu_integration_settings[facebook_customer_chat][status]"><?php esc_html_e( 'Status', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					id="wacu_integration_settings[facebook_customer_chat][status]"
					type="checkbox" <?php checked( 'yes', wacu_integration_option( 'facebook_customer_chat', 'status' ), true ); ?>
					name="wacu_integration_settings[facebook_customer_chat][status]"> <label for="wacu_integration_settings[facebook_customer_chat][status]"><?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' ); ?></label>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_integration_settings[facebook_customer_chat][page_id]"><?php esc_attr_e( 'Facebook Page ID', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_integration_settings[facebook_customer_chat][page_id]"
					class="regular-text"
					name="wacu_integration_settings[facebook_customer_chat][page_id]"
					value="<?php echo esc_attr( wacu_integration_option( 'facebook_customer_chat', 'page_id' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Background Color', 'wp-any-contact-us' );?></label>
			</th>
			<td>
				<input type="text" class="wacu-color-picker" name="wacu_integration_settings[facebook_customer_chat][background_color]" value="<?php echo esc_attr( wacu_integration_option( 'facebook_customer_chat', 'background_color' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Default %s', 'wp-any-contact-us' ), '<code>#0084ff</code>' );?></p>
			</td>
		</tr>
	</tbody>
</table>
<hr>
<h3><?php esc_html_e( 'Tawk.to', 'wp-any-contact-us' ); ?></h3>
<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for="wacu_integration_settings[tawk_to][status]"><?php esc_html_e( 'Status', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					id="wacu_integration_settings[tawk_to][status]"
					type="checkbox" <?php checked( 'yes', wacu_integration_option( 'tawk_to', 'status' ), true ); ?>
					name="wacu_integration_settings[tawk_to][status]"> <label for="wacu_integration_settings[tawk_to][status]"><?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' ); ?></label>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_integration_settings[tawk_to][site_id]"><?php esc_html_e( 'Site ID', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_integration_settings[tawk_to][site_id]"
					class="regular-text"
					name="wacu_integration_settings[tawk_to][site_id]"
					value="<?php echo esc_attr( wacu_integration_option( 'tawk_to', 'site_id' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_integration_settings[tawk_to][widget_name]"><?php esc_html_e( 'Widget Name', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_integration_settings[tawk_to][widget_name]"
					class="regular-text"
					name="wacu_integration_settings[tawk_to][widget_name]"
					value="<?php echo esc_attr( wacu_integration_option( 'tawk_to', 'widget_name' ) ); ?>">
			</td>
		</tr>
	</tbody>
</table>
<hr>
<h3><?php esc_html_e( 'WordPress WhatsApp Support', 'wp-any-contact-us' ); ?></h3>
<p class="description"><?php esc_html_e( 'Required WordPress WhatsApp Support version 2.0.4 or higher.', 'wp-any-contact-us' ); ?></p>
<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for="wacu_integration_settings[wordpress_whatsapp_support][status]"><?php esc_html_e( 'Status', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					id="wacu_integration_settings[wordpress_whatsapp_support][status]"
					type="checkbox" <?php checked( 'yes', wacu_integration_option( 'wordpress_whatsapp_support', 'status' ), true ); ?>
					name="wacu_integration_settings[wordpress_whatsapp_support][status]"> <label for="wacu_integration_settings[wordpress_whatsapp_support][status]"><?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' ); ?></label>
			</td>
		</tr>
	</tbody>
</table>
<?php submit_button(); ?>
