<?php
defined( 'ABSPATH' ) || exit;

function wacu_page_dropdown( $args = '' ) {
	$html     = '';
	$name     = isset( $args['name'] ) ? "name='{$args['name']}'" : '';
	$id       = isset( $args['id'] ) ? "id='{$args['id']}'" : '';
	$class    = isset( $args['class'] ) ? "class='{$args['class']}'" : '';
	$multiple = ( isset( $args['multiple'] ) && true === $args['multiple'] ) ? 'multiple' : '';
	$selected = ( isset( $args['selected'] ) ) ? $args['selected'] : '';
	$pages    = new WP_Query(
		array(
			'post_type'      => 'page',
			'posts_per_page' => -1,
			'post_status'    => 'publish',
		)
	);

	if ( $pages->have_posts() ) {
		$html .= "<select $name $id $class $multiple>";
		while ( $pages->have_posts() ) { $pages->the_post();
			if ( 'multiple' === $multiple ) {
				$select = ( in_array( get_the_ID(), (array)$selected ) ) ? 'selected' : '';
				$html .= '<option value="' . get_the_ID() . '" ' . $select . ' >' . get_the_title() . '</option>';
			} else {
				$select = ( get_the_ID() == $selected ) ? 'selected' : '';
				$html .= '<option value="' . get_the_ID() . '" ' . $select . ' >' . get_the_title() . '</option>';
			}
		}
		$html .= "</select>";
	}

	echo $html;
}
