<?php
defined( 'ABSPATH' ) || exit;

class WACU_Enqueue {

	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 200 );
	}

	/**
	 * Enqueue frontend script and style files.
	 */
	public function enqueue_scripts() {
		$css  = '';

		/**
		 * Register Google reCAPTCHA script.
		 *
		 * @since 2.1.0
		 */
		wp_register_script( 'wacu-grecaptcha', 'https://www.google.com/recaptcha/api.js?onload=wacuGreCatchaCallbacK&render=explicit', array(), '1.0.0', true );

		// Load Google reCAPTCHA script on conditional only.
		if ( wacu_grecaptcha_option( 'v2_site_key' ) ) {
			$grecaptcha = "var wacuGreCatchaCallbacK = function() {";

			if ( 'yes' === wacu_email_us_option( 'grecaptcha' ) ) {
				$grecaptcha .= "grecaptcha.render( 'wacu-grecaptcha-v2-email-us', {
					'sitekey' : '" . esc_html( wacu_grecaptcha_option( 'v2_site_key' ) ) . "',
					'theme' : 'light'
				} );";
			}

			if ( 'yes' === wacu_schedule_call_option( 'grecaptcha' ) ) {
				$grecaptcha .= "grecaptcha.render( 'wacu-grecaptcha-v2-schedule-call', {
					'sitekey' : '" . esc_html( wacu_grecaptcha_option( 'v2_site_key' ) ) . "',
					'theme' : 'light'
				} );";
			}

			$grecaptcha .= "};";

			wp_enqueue_script( 'wacu-grecaptcha' );
			wp_add_inline_script( 'wacu-grecaptcha', $grecaptcha );

		}

		wp_enqueue_style( 'wacu-style', WACU_PLUGIN_URL . 'assets/css/wacu-public-style.css', array(), WACU_PLUGIN_VER );
		wp_enqueue_script( 'wacu-script', WACU_PLUGIN_URL . 'assets/js/wacu-public-script.js', array(), WACU_PLUGIN_VER, true );

		wp_localize_script(
			'wacu-script',
			'wacuObj', // Object name
			apply_filters(
				'wacu_localize_script',
				array(
					'ajax_url'                    => admin_url( 'admin-ajax.php' ),
					'check_icon'                  => WACU_Icon::get( 'check' ),
					'smart_popup_status'          => wacu_smart_popup_option( 'status' ),
					'smart_popup_delay'           => wacu_smart_popup_option( 'delay' ),
					'smart_popup_interval'        => wacu_smart_popup_option( 'interval' ),
					'smart_popup_typing_time'     => wacu_smart_popup_option( 'typing_time' ),
					'smart_popup_message_time'    => wacu_smart_popup_option( 'message_time' ),
					'is_gdpr'                     => wacu_gdpr_option( 'status' ),
					'trigger_effect'              => wacu_appearance_option( 'trigger_effect' ),
					'trigger_type'                => wacu_appearance_option( 'trigger_type' ),
					'is_email_us_grecaptcha'      => 'yes' === wacu_email_us_option( 'grecaptcha' ) ? true : false,
					'is_schedule_call_grecaptcha' => 'yes' === wacu_schedule_call_option( 'grecaptcha' ) ? true : false,
				)
			)
		);

		$css .= '.wacu-color {
			color: ' . esc_html( wacu_appearance_option( 'text_color' ) ) . ';
		}
		.wacu-bg-color {
			background-color: ' . esc_html( wacu_appearance_option( 'background_color' ) ) . ';
		}';

		// Color Appearance
		$css .= '
		.wacu-widget-trigger,
		.wacu-popup__header,
		.wacu-sub-popup__header,
		.wacu-schedule-call input[type="submit"],
		.wacu-email-us input[type="submit"] {
			color: ' . esc_html( wacu_appearance_option( 'text_color' ) ) . ';
			background-color: ' . esc_html( wacu_appearance_option( 'background_color' ) ) . ';
		}';

		if ( 'icon_only' === wacu_appearance_option( 'trigger_type' ) ) {

			// Trigger size
			$css .= '.wacu-trigger {
				width: ' . absint( wacu_appearance_option( 'trigger_size' ) ) . 'px;
				height: ' . absint( wacu_appearance_option( 'trigger_size' ) ) . 'px;
			}';

			// Trigger icon size
			$css .= '.wacu-trigger svg {
				width: ' . absint( wacu_appearance_option( 'trigger_icon_size' ) ) . 'px;
				height: ' . absint( wacu_appearance_option( 'trigger_icon_size' ) ) . 'px;
			}';

		}

		// Popup ::after bottom arrow
		$css .= '.wacu-br .wacu-popup:after,
		.wacu-br .wacu-sub-popup:after,
		.wacu-br .wacu-smart-popup:after {
			right: calc( ' . absint( wacu_appearance_option( 'trigger_size' ) ) . 'px / 2.2 );
		}
		.wacu-bl .wacu-popup:after,
		.wacu-bl .wacu-sub-popup:after,
		.wacu-bl .wacu-smart-popup:after {
			left: calc( ' . absint( wacu_appearance_option( 'trigger_size' ) ) . 'px / 2.2 );
		}';

		// Trigger offset
		$css .= '.wacu-widget.wacu-br {
			right: ' . absint( wacu_appearance_option( 'trigger_offset_x' ) ) . 'px;
			bottom: ' . absint( wacu_appearance_option( 'trigger_offset_y' ) ) . 'px;
		}
		.wacu-widget.wacu-bl {
			left: ' . absint( wacu_appearance_option( 'trigger_offset_x' ) ) . 'px;
			bottom: ' . absint( wacu_appearance_option( 'trigger_offset_y' ) ) . 'px;
		}';

		// Trigger ripple effect
		if ( 'ripple' === wacu_appearance_option( 'trigger_effect' ) ) {
			$ripple_color = wacu_hex2rgba( wacu_appearance_option( 'background_color' ), '0.4' );

			$css .= ".wacu-trigger--ripple::after,
			.wacu-trigger--ripple::before {
				border: 8px solid rgba( {$ripple_color['red']}, {$ripple_color['green']}, {$ripple_color['blue']}, {$ripple_color['alpha']} );
			}";
		}

		// Mobile responsive CSS
		$css .= '@media ( max-width: 426px ) {
			.wacu-popup__header-cta,
			.wacu-sub-popup__header-cta {
				background-color: ' . esc_html( wacu_appearance_option( 'background_color' ) ) . ';
			}
		}';

		// Custom CSS
		$css .= wp_kses_post( wacu_basic_setting_option( 'custom_css' ) );

		wp_add_inline_style( 'wacu-style', $css );
	}

}

$wacu_enqueue = new WACU_Enqueue;
