<?php
defined( 'ABSPATH' ) || exit;

class WACU_Schedule_Call {

	public function __construct() {
		add_shortcode( 'wacu_schedule_call', array( $this, 'display_schedule_call' ) );
		add_action( 'wp_ajax_wacu_schedule_call_submit', array( $this, 'schedule_call_submit' ) );
		add_action( 'wp_ajax_nopriv_wacu_schedule_call_submit', array( $this, 'schedule_call_submit' ) );
	}

	public function schedule_call_submit() {
		if ( $_POST['wacu_schedule_call_security']
			&& wp_verify_nonce( $_POST['wacu_schedule_call_security'], 'wacu_schedule_call_submit' ) ) {
			// Default response
			$response = array(
				'status'  => 0,
				'message' => '',
			);

			// Form inputs
			$name     = sanitize_text_field( $_POST['wacu_schedule_call_name'] );
			$country  = isset( $_POST['wacu_schedule_call_country'] ) ? sanitize_text_field( $_POST['wacu_schedule_call_country'] ) : '';
			$number   = sanitize_text_field( $_POST['wacu_schedule_call_number'] );
			$month    = isset( $_POST['wacu_schedule_call_month'] ) ? sanitize_text_field( $_POST['wacu_schedule_call_month'] ) : '';
			$date     = isset( $_POST['wacu_schedule_call_date'] ) ? sanitize_text_field( $_POST['wacu_schedule_call_date'] ) : '';
			$time     = isset( $_POST['wacu_schedule_call_time'] ) ? sanitize_text_field( $_POST['wacu_schedule_call_time'] ) : '';
			$message  = isset( $_POST['wacu_schedule_call_message'] ) ? sanitize_textarea_field( $_POST['wacu_schedule_call_message'] ) : '';

			// Date format
			$callback_time = "$month $date, $time";

			// Schedule call settings
			$to               = wacu_schedule_call_option( 'email_to' );
			$cc               = wacu_schedule_call_option( 'email_cc' );
			$bcc              = wacu_schedule_call_option( 'email_bcc' );
			$subject          = wacu_schedule_call_option( 'email_subject' );
			$email_body       = wacu_schedule_call_option( 'email_body' );
			$email_from_name  = wacu_schedule_call_option( 'email_from_name' );
			$email_from_email = wacu_schedule_call_option( 'email_from_email' );

			// Send an email
			// Email data
			$subject = str_replace(
				array(
					'{{name}}',
					'{{current_time}}',
				),
				array(
					$name,
					wacu_get_current_time(),
				),
				$subject
			);

			$body = str_replace(
				array(
					'{{name}}',
					'{{country}}',
					'{{callback_number}}',
					'{{callback_time}}',
					'{{message}}',
					'{{page_title}}',
					'{{page_url}}',
					'{{current_time}}',
				),
				array(
					$name,
					$country,
					$number,
					$callback_time,
					$message,
					$_POST['page_title'], // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					$_POST['page_url'], // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					wacu_get_current_time(),
				),
				wp_kses_post( wpautop( $email_body ) )
			);

			$headers[] = 'Content-Type: text/html; charset=UTF-8';

			// Set from header
			if ( $email_from_name && $email_from_email ) {
				$headers[] = 'From: ' . esc_html( $email_from_name ) . ' <' . esc_html( $email_from_email ) . '>';
			}

			// Set Cc
			if ( $cc ) {
				$headers[] = "Cc: $cc";
			}
			// Set Bcc
			if ( $bcc ) {
				$headers[] = "Bcc: $bcc";
			}

			$mail = wp_mail( $to, $subject, $body, $headers );

			if ( $mail ) {
				$response['status']  = 1;
				$response['message'] = str_replace(
					array(
						'{{name}}',
					),
					array(
						$name,
					),
					wp_kses_post( wacu_schedule_call_option( 'thank_you_message' ) )
				);
			}

			echo wp_json_encode( $response );
		}
		wp_die();
	}

	public function display_schedule_call() {
		ob_start();

		require_once WACU_PLUGIN_PATH . '/templates/schedule-call.php';
		return ob_get_clean();
	}
}

new WACU_Schedule_Call;
