<?php defined( 'ABSPATH' ) || exit; ?>
<div class="wacu-email-us">
	<form class="wacu-email-us-form" action="#" method="post">
		<?php wp_nonce_field( 'wacu_email_us_submit', 'wacu_email_us_security' ); ?>
		<input type="hidden" name="page_title" value="<?php the_title(); ?>">
		<input type="hidden" name="page_url" value="<?php the_permalink(); ?>">

		<div class="wacu-email-us__item">
			<div class="wacu-email-us__label">
				<label for=""><?php echo esc_html( wacu_email_us_option( 'label_full_name' ) ); ?></label>
			</div>
			<div class="wacu-email-us__input-type">
				<input type="text" name="wacu_email_us_name" data-wacu-email-us-required="1" autocomplete="new-password">
			</div>
		</div>
		<div class="wacu-email-us__item">
			<div class="wacu-email-us__label">
				<label for=""><?php echo esc_html( wacu_email_us_option( 'label_email_address' ) ); ?></label>
			</div>
			<div class="wacu-email-us__input-type">
				<input type="email" name="wacu_email_us_email" data-wacu-email-us-required="1">
			</div>
		</div>
		<div class="wacu-email-us__item">
			<div class="wacu-email-us__label">
				<label for=""><?php echo esc_html( wacu_email_us_option( 'label_email_message' ) ); ?></label>
			</div>
			<div class="wacu-email-us__input-type">
				<textarea name="wacu_email_us_message"></textarea>
			</div>
		</div>

		<?php if ( 'yes' === wacu_email_us_option( 'grecaptcha' ) ) : ?>
		<div class="wacu-email-us__item">
			<div id="wacu-grecaptcha-v2-email-us" style="transform:scale(0.95);transform-origin:0 0;width:305px;"></div>
		</div>
		<?php endif; ?>
		<div>
			<input type="submit" value="<?php echo esc_attr( wacu_email_us_option( 'label_button' ) ); ?>">
		</div>
	</form>
	<div class="wacu-email-us-loader wacu-hide">
		<div class="wacu-spinner">
			<div class="double-bounce1 wacu-bg-color"></div>
			<div class="double-bounce2 wacu-bg-color"></div>
		</div>
	</div>
	<div class="wacu-email-us-response wacu-hide"></div>
</div>
