<?php

class SMEGA_MENU_PRO_licence {

	function __construct() {
		//$this->licence_deactivation_check();
	}

	/**
	 * Retrieve licence details
	 */
	public function get_licence_data() {
		$licence_data = get_site_option( 'smega_menu_license_key' );

		$default      = array(
			'key'            => '',
			'last_check'     => 0,
			'licence_status' => '',
			'licence_expire' => '',
		);
		$licence_data = wp_parse_args( $licence_data, $default );

		return $licence_data;
	}


	/**
	 * Reset license data
	 *
	 * @param mixed $licence_data
	 */
	public function reset_licence_data( $licence_data ) {
		if ( ! is_array( $licence_data ) ) {
			$licence_data = array();
		}

		$licence_data['key']            = '';
		$licence_data['last_check']     = time();
		$licence_data['licence_status'] = '';
		$licence_data['licence_expire'] = '';

		return $licence_data;
	}

	/**
	 * Set licence data
	 *
	 * @param mixed $licence_data
	 */
	public function update_licence_data( $licence_data ) {
		update_site_option( 'smega_menu_license_key', $licence_data );
	}

	public function licence_key_verify() {
		$licence_data = $this->get_licence_data();

		if ( $this->is_local_instance() ) {
			return true;
		}

		if ( ! isset( $licence_data['key'] ) || '' === $licence_data['key'] ) {
			return false;
		}

		return true;
	}

	public function is_local_instance() {
		return false;
	}


	public function licence_deactivation_check() {
		if ( ! $this->licence_key_verify() ) {
			return;
		}

		// do not trigger if on server API.
		$api_parse_url = wp_parse_url( SMEGA_MENU_APP_API_URL );
		if ( SMEGA_MENU_INSTANCE === $api_parse_url['host'] ) {
			return;
		}

		$licence_data = $this->get_licence_data();

		if ( isset( $licence_data['last_check'] ) ) {
			if ( time() < ( $licence_data['last_check'] + ( 86400 * 2 ) ) ) {
				return;
			}
		}

		$licence_key = $licence_data['key'];

		$args = array(
			'woo_sl_action'     => 'status-check',
			'licence_key'       => $licence_key,
			'product_unique_id' => SMEGA_MENU_PRODUCT_ID,
			'domain'            => SMEGA_MENU_INSTANCE,
			'code_version'      => SMEGA_MENU_VERSION,
			// '_get_product_meta' => '_sl_new_version',.
		);
		$request_uri = SMEGA_MENU_APP_API_URL . '?' . http_build_query( $args, '', '&' );
		$data        = wp_safe_remote_get( $request_uri );

		if ( is_wp_error( $data ) || 200 !== $data['response']['code'] ) {
				$licence_data['last_check'] = time();
				$this->update_licence_data( $licence_data );
				return;
		}

		$response_block = json_decode( $data['body'] );

		if ( ! is_array( $response_block ) || count( $response_block ) < 1 ) {
				$licence_data['last_check'] = time();
				$this->update_licence_data( $licence_data );
				return;
		}

		$response_block = $response_block[ count( $response_block ) - 1 ];
		if ( is_object( $response_block ) ) {
			if ( in_array( $response_block->status_code, array( 'e312', 's203', 'e204', 'e002', 'e003' ) ) ) {
					$licence_data = $this->reset_licence_data( $licence_data );
			} else {
				$licence_data['licence_status']  = isset( $response_block->licence_status ) ? $response_block->licence_status : '';
				$licence_data['licence_expire']  = isset( $response_block->licence_expire ) ? $response_block->licence_expire : '';
				$licence_data['_sl_new_version'] = isset( $response_block->_sl_new_version ) ? $response_block->_sl_new_version : '';
			}

			if ( 'error' === $response_block->status ) {
					$licence_data = $this->reset_licence_data( $licence_data );
			}
		}

		$licence_data['last_check'] = time();
		$this->update_licence_data( $licence_data );
	}
}