<?php defined( 'ABSPATH' ) || exit;?>
<div class="wrap">
	<h1><?php esc_html_e( 'GDPR Settings', 'wp-any-contact-us' );?></h1>
	<?php settings_errors();?>
	<hr>

	<form action="options.php" method="post">
		<?php settings_fields( 'wacu_gdpr_settings_option_group' );?>
		<table class="form-table">
			<tbody>
				<tr>
					<th scopr="row">
						<label for="wacu_gdpr_settings[status]"><?php esc_html_e( 'GDPR', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<input
							type="checkbox"
							name="wacu_gdpr_settings[status]"
							id="wacu_gdpr_settings[status]"
							<?php checked( 'yes', wacu_gdpr_option( 'status' ), true );?>>
						<label for="wacu_gdpr_settings[status]"><?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' );?></label>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="wacu_gdpr_settings[location]"><?php esc_html_e( 'GDPR Location', 'wp-any-contact-us' ); ?></label>
					</th>
					<td>
						<select name="wacu_gdpr_settings[location]" id="wacu_gdpr_settings[location]">
							<option value="wacu_before_popup_body" <?php selected( 'wacu_before_popup_body', wacu_gdpr_option( 'location' ) ); ?>><?php esc_html_e( 'Before Popup Body', 'wp-any-contact-us' ) ?></option>
							<option value="wacu_after_popup_body" <?php selected( 'wacu_after_popup_body', wacu_gdpr_option( 'location' ) ); ?>><?php esc_html_e( 'After Popup Body', 'wp-any-contact-us' ) ?></option>
						</select>
					</td>
				</tr>
				<tr>
					<th scopr="row">
						<label for="wacu_gdpr_settings[message]"><?php esc_html_e( 'GDPR Message', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<textarea name="wacu_gdpr_settings[message]" id="wacu_gdpr_settings[message]" class="regular-text" cols="50" rows="5"><?php echo esc_textarea( wacu_gdpr_option( 'message' ) ); ?></textarea>
						<p class="description"><?php printf( esc_html__( 'Use tag %s for privacy page.', 'wp-any-contact-us' ), '<code>{{privace_page}}</code>' );?></p>
					</td>
				</tr>
				<tr>
					<th scopr="row">
						<label for="wacu_gdpr_settings[privacy_page]"><?php esc_html_e( 'Privacy page', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<?php
							wacu_page_dropdown(
								array(
									'name'     => 'wacu_gdpr_settings[privacy_page]',
									'id'       => 'wacu_gdpr_settings[privacy_page]',
									'selected' => wacu_gdpr_option( 'privacy_page' ),
								)
							);
						?>
					</td>
				</tr>
			</tbody>
		</table>
		<?php submit_button();?>
	</form>

</div>
