<?php settings_fields( 'wacu_schedule_call_settings_option_group' ); ?>
<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for=""><?php esc_html_e( 'Input Field Settings', 'wp-any-contact-us' ); ?></label>
			</td>
			<td>
				<p>
					<input
						type="checkbox"
						name="wacu_schedule_call_settings[field_country]"
						id="wacu_schedule_call_settings[field_country]"
						<?php checked( 'yes', wacu_schedule_call_option( 'field_country' ), true ); ?>>
					<label for="wacu_schedule_call_settings[field_country]">
						<?php esc_html_e( 'Country Field', 'wp-any-contact-us' ); ?>
					</label>
				</p>
				<p>
					<input
						type="checkbox"
						name="wacu_schedule_call_settings[field_schedule_time]"
						id="wacu_schedule_call_settings[field_schedule_time]"
						<?php checked( 'yes', wacu_schedule_call_option( 'field_schedule_time' ), true ); ?>>
					<label for="wacu_schedule_call_settings[field_schedule_time]">
						<?php esc_html_e( 'Schedule Time Field', 'wp-any-contact-us' ); ?>
					</label>
				</p>
				<p>
					<input
						type="checkbox"
						name="wacu_schedule_call_settings[field_message]"
						id="wacu_schedule_call_settings[field_message]"
						<?php checked( 'yes', wacu_schedule_call_option( 'field_message' ), true ); ?>>
					<label for="wacu_schedule_call_settings[field_message]">
						<?php esc_html_e( 'Message Field', 'wp-any-contact-us' ); ?>
					</label>
				</p>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<hr>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[label_full_name]"><?php esc_html_e( 'Label For Full Name', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[label_full_name]"
					class="regular-text"
					name="wacu_schedule_call_settings[label_full_name]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'label_full_name' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[label_country]"><?php esc_html_e( 'Label For Country', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[label_country]"
					class="regular-text"
					name="wacu_schedule_call_settings[label_country]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'label_country' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[label_callback_number]"><?php esc_html_e( 'Label For Callback Number', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[label_callback_number]"
					class="regular-text"
					name="wacu_schedule_call_settings[label_callback_number]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'label_callback_number' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[label_schedule_time]"><?php esc_html_e( 'Label For Schedule Time', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[label_schedule_time]"
					class="regular-text"
					name="wacu_schedule_call_settings[label_schedule_time]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'label_schedule_time' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[label_message]"><?php esc_html_e( 'Label For Message', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[label_message]"
					class="regular-text"
					name="wacu_schedule_call_settings[label_message]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'label_message' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[label_button]"><?php esc_html_e( 'Label For Button', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[label_button]"
					class="regular-text"
					name="wacu_schedule_call_settings[label_button]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'label_button' ) ); ?>">
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[email_subject]"><?php esc_html_e( 'Email Subject', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[email_subject]"
					class="regular-text"
					name="wacu_schedule_call_settings[email_subject]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'email_subject' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Full name.', 'wp-any-contact-us' ), '<code>{{name}}</code>' ); ?></p>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Current Time.', 'wp-any-contact-us' ), '<code>{{current_time}}</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings_email_body"><?php esc_html_e( 'Email Body', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<div style="width: 550px; max-width: 100%;">
					<?php
						wp_editor(
							wp_kses_post( wacu_schedule_call_option( 'email_body' ) ),
							'wacu_email_us_settings_email_body',
							array(
								'editor_height' => 200,
								'textarea_name' => 'wacu_schedule_call_settings[email_body]',
							)
						);
					?>
					<p class="description"><?php printf( esc_html__( 'Use tag %s for Full name.', 'wp-any-contact-us' ), '<code>{{name}}</code>' ); ?></p>
					<p class="description"><?php printf( esc_html__( 'Use tag %s for Country.', 'wp-any-contact-us' ), '<code>{{country}}</code>' ); ?></p>
					<p class="description"><?php printf( esc_html__( 'Use tag %s for Callback Number.', 'wp-any-contact-us' ), '<code>{{callback_number}}</code>' ); ?></p>
					<p class="description"><?php printf( esc_html__( 'Use tag %s for Callback Time.', 'wp-any-contact-us' ), '<code>{{callback_time}}</code>' ); ?></p>
					<p class="description"><?php printf( esc_html__( 'Use tag %s for Message.', 'wp-any-contact-us' ), '<code>{{message}}</code>' ); ?></p>
					<p class="description"><?php printf( esc_html__( 'Use tag %s for Page Title.', 'wp-any-contact-us' ), '<code>{{page_title}}</code>' ); ?></p>
					<p class="description"><?php printf( esc_html__( 'Use tag %s for Page URL.', 'wp-any-contact-us' ), '<code>{{page_url}}</code>' ); ?></p>
					<p class="description"><?php printf( esc_html__( 'Use tag %s for Current Time.', 'wp-any-contact-us' ), '<code>{{current_time}}</code>' ); ?></p>
				</div>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[email_to]"><?php esc_html_e( 'Email To', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[email_to]"
					class="regular-text"
					name="wacu_schedule_call_settings[email_to]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'email_to' ) ); ?>">
				<p class="description"><?php esc_html_e( 'Use comma (,) separator for multiple emails.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[email_cc]"><?php esc_html_e( 'Email CC', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[email_cc]"
					class="regular-text"
					name="wacu_schedule_call_settings[email_cc]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'email_cc' ) ); ?>">
				<p class="description"><?php esc_html_e( 'Use comma (,) separator for multiple emails.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[email_bcc]"><?php esc_html_e( 'Email BCC', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[email_bcc]"
					class="regular-text"
					name="wacu_schedule_call_settings[email_bcc]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'email_bcc' ) ); ?>">
				<p class="description"><?php esc_html_e( 'Use comma (,) separator for multiple emails.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[email_from_name]"><?php esc_html_e( 'Email From Name', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[email_from_name]"
					class="regular-text"
					name="wacu_schedule_call_settings[email_from_name]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'email_from_name' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Best practice %s', 'wp-any-contact-us' ), '<code>' . get_bloginfo( 'name' ) . '</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[email_from_email]"><?php esc_html_e( 'Email From Email', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_schedule_call_settings[email_from_email]"
					class="regular-text"
					name="wacu_schedule_call_settings[email_from_email]"
					value="<?php echo esc_attr( wacu_schedule_call_option( 'email_from_email' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Best practice %s', 'wp-any-contact-us' ), '<code>' . get_bloginfo( 'admin_email' ) . '</code>' ); ?></p>
				<div style="margin-top: 10px;">
					<img src="<?php echo WACU_PLUGIN_URL . 'assets/images/email-us-img1.jpg'; ?>" alt="//">
				</div>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings_thank_you_message"><?php esc_html_e( 'Thank You Message', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<div style="width: 550px; max-width: 100%;">
					<?php
						wp_editor(
							wp_kses_post( wacu_schedule_call_option( 'thank_you_message' ) ),
							'wacu_schedule_call_settings_thank_you_message',
							array(
								'editor_height' => 200,
								'textarea_name' => 'wacu_schedule_call_settings[thank_you_message]',
							)
						);
					?>
				</div>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Full name.', 'wp-any-contact-us' ), '<code>{{name}}</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_schedule_call_settings[grecaptcha]"><?php esc_attr_e( 'Google reCAPTCHA v2', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<label for="wacu_schedule_call_settings[grecaptcha]">
					<input
						type="checkbox"
						id="wacu_schedule_call_settings[grecaptcha]"
						name="wacu_schedule_call_settings[grecaptcha]"
						value="yes"
						<?php checked( 'yes', wacu_schedule_call_option( 'grecaptcha' ) ); ?> >
						<span><?php esc_html_e( 'Enable/ Disable', 'wp-any-contact-us' ); ?></span>
					<p class="description">
					<?php
						echo wp_kses_post(
							sprintf(
								__( 'Enter Google reCAPTCHA v2 keys <a href="%s" target="_blank">here</a>', 'wp-any-contact-us' ),
								admin_url( 'admin.php?page=wp-any-contact-us_grecaptcha' )
							)
						);
					?>
					</p>
				</label>

			</td>
		</tr>
	</tbody>
</table>
<?php submit_button(); ?>
