<?php
defined( 'ABSPATH' ) || exit;

class WACU_Buttons {

	public function __construct() {
		add_shortcode( 'wacu_button', array( $this, 'output' ) );
	}

	public function output( $atts ) {
		if ( ! isset( $atts['id'] ) ) {
			return false;
		}

		// Return false if post is not exists or not our post type.
		if ( ! get_post_status( $atts['id'] ) || 'wacu_social_contact' !== get_post_type( $atts['id'] )  ) {
			return false;
		}

		$inline_css     = array();
		$classes        = array();
		$social_contact = wacu_get_social_contact( $atts['id'] );
		$a              = wp_parse_args( $atts, $social_contact );

		// Visibility conditions.
		if ( 1 == $a['register_only'] && ! is_user_logged_in() ) {
			return false;
		}
		if ( 0 == $a['device'] ) {
			return false;
		}
		if ( 1 == $a['device'] && ! wp_is_mobile() ) {
			return false;
		}
		if ( 2 == $a['device'] && wp_is_mobile() ) {
			return false;
		}

		// Extra arguments.
		$a['bg_color']   = isset( $a['bg_color'] ) ? esc_attr( $a['bg_color'] ) : esc_attr( $a['icon_color'] );
		$a['text_color'] = isset( $a['text_color'] ) ? esc_attr( $a['text_color'] ) : '#ffffff';
		$a['style']      = isset( $a['style'] ) ? esc_attr( $a['style'] ) : 'solid';
		$a['size']       = isset( $a['size'] ) ? esc_attr( $a['size'] ) : 'medium';

		if ( 'solid' === $a['style'] ) {
			$inline_css[] = "background-color: {$a['bg_color']}";
			$inline_css[] = "color: {$a['text_color']}";
		} else {
			$inline_css[] = "color: {$a['bg_color']}";
		}

		$inline_css[] = "border-color: {$a['bg_color']}";

		// Classes
		$classes[] = 'solid' === $a['style'] ? 'wacu-button--solid' : 'wacu-button--outline';

		if ( 'small' === $a['size'] ) {
			$classes[] = 'wacu-button--small';
		} else if ( 'large' === $a['size'] ) {
			$classes[] = 'wacu-button--large';
		} else if ( 'hero' === $a['size'] ) {
			$classes[] = 'wacu-button--hero';
		} else {
			$classes[] = 'wacu-button--medium';
		}

		// ob starts.
		ob_start();
		?>

		<a
			<?php if ( 1 == $a['type'] ) : ?>
				href="<?php echo wp_kses_post( wacu_template_variables( $a['link'] ) ); ?>"
			<?php elseif ( 3 == $a['type'] ) : ?>
				href="javascript:void( jQuery( '[data-wacu-integration-trigger=<?php echo esc_attr( $a['integration'] ); ?>]' ).click() )"
			<?php endif; ?>
			id="wacu-button-<?php echo esc_attr( $a['id'] ); ?>"
			class="wacu-button <?php echo  implode( ' ', $classes );// WPCS: XSS ok ?>"
			style="<?php echo implode( '; ', $inline_css ); // WPCS: XSS ok ?>"
			target="<?php echo esc_attr( $a['target'] ); ?>">

			<?php if ( $icon = WACU_Icon::get( $a['icon'] ) ) : ?>
				<?php echo $icon; // WPCS: XSS ok ?>
			<?php else: ?>
				<?php echo wp_kses_post( $a['icon'] ); ?>
			<?php endif; ?>

			<?php echo esc_html( $a['title'] ); ?>
		</a>

		<?php
		return ob_get_clean();
	}

}

new WACU_Buttons;
