<?php
defined( 'ABSPATH' ) || exit;

class WACU_Install {

	public static function install() {

		/**
		 * HOOK: wacu_before_plugin_install.
		 */
		do_action( 'wacu_before_plugin_install' );

		self::register_options();

		/**
		 * HOOK: wacu_after_plugin_install.
		 */
		do_action( 'wacu_after_plugin_install' );

		// update current version.
		update_option( 'wacu_version', WACU_PLUGIN_VER );
	}

	public static function register_options() {
		foreach ( self::default_options() as $option => $value ) {
			$db_options = get_option( $option );
			if ( ! $db_options ) { // Run when install
				update_option( $option, $value );
			} else { // Run when update
				$merged_option = self::parse_args_r( $db_options, $value );
				update_option( $option, $merged_option );
			}
		}
	}

	public static function default_options() {
		return apply_filters( 'wacu_default_options', array(
			'wacu_appearance_settings'    => array(
				'background_color'  => '#24303f',
				'text_color'        => '#ffffff',
				'widget_location'   => 'br',
				'trigger_type'		=> 'icon_only',
				'trigger_text'      => 'Hi, How can we help!',
				'trigger_size'      => '60',
				'trigger_icon_size' => '32',
				'trigger_offset_x'  => '16',
				'trigger_offset_y'  => '16',
				'trigger_icon'      => 'comments',
				'trigger_effect'    => 'ripple',
				'trigger_animation' => 'no',
			),
			'wacu_basic_settings'         => array(
				'widget_status'           => 'yes',
				'display_on_mobile'       => 'yes',
				'display_on_desktop'      => 'yes',
				'filter_by_everywhere'    => 'yes',
				'filter_include_by_page'  => array(),
				'filter_by_regester_user' => 'no',
				'custom_css'              => '',
			),
			'wacu_text_settings'          => array(
				'header_text' => 'How would like to contact us?',
			),
			'wacu_smart_popup_settings'   => array(
				'status'       => 'yes',
				'delay'        => '5',
				'interval'     => '300',
				'typing_time'  => '2',
				'message_time' => '4',
			),
			'wacu_email_us_settings'      => array(
				'label_full_name'     => 'Enter your full name',
				'label_email_address' => 'Enter your email address',
				'label_email_message' => 'Enter message',
				'label_button'        => 'Send Email',
				'email_subject'       => 'New Email Request - {{name}} - demo',
				'email_body'          => '<p>You received a new email request<br> Details are following:<br> <strong>Name:</strong> {{name}}<br> <strong>Email:</strong> {{email}}<br> <strong>Message:</strong> {{message}}</p>',
				'email_to'            => get_option( 'admin_email' ),
				'email_cc'            => '',
				'email_bcc'           => '',
				'email_from_name'     => get_bloginfo( 'name' ),
				'email_from_email'    => get_option( 'admin_email' ),
				'thank_you_message'   => '<h4 style="text-align: center;">Thank you, {{name}},</h4><p style="text-align: center;">We will contact you shortly.</p>',
				'grecaptcha'          => 'no',
			),
			'wacu_schedule_call_settings' => array(
				'field_country'         => 'no',
				'field_schedule_time'   => 'no',
				'field_message'         => 'yes',
				'label_full_name'       => 'Enter your full name',
				'label_country'         => 'Select country',
				'label_callback_number' => 'Enter callback number',
				'label_schedule_time'   => 'Choose schedule time',
				'label_message'         => 'Enter Message',
				'label_button'          => 'Schedule a Call',
				'email_subject'         => 'Schedule a call request - {{name}}',
				'email_body'            => '<p>You received a new callback request<br />Details are following:<br /><strong>Name:</strong> {{name}}<br /><strong>Country:</strong> {{country}}<br /><strong>Callback Number:</strong> {{callback_number}}<br /><strong>Callback Time:</strong> {{callback_time}}<br /><strong>Message:</strong> {{message}}</p>',
				'email_to'              => get_option( 'admin_email' ),
				'email_cc'              => '',
				'email_bcc'             => '',
				'email_from_name'       => get_option( 'name' ),
				'email_from_email'      => get_option( 'admin_email' ),
				'thank_you_message'     => '<h4 style="text-align: center">Thank you, {{name}},</h4><p style="text-align: center">We will contact you shortly.</p>',
				'grecaptcha'            => 'no',
			),
			'wacu_gdpr_settings'          => array(
				'status'       => 'no',
				'message'      => 'I agree to all the {{privacy_page}}',
				'privacy_page' => get_option( 'page_on_front' ),
				'location'     => 'wacu_after_popup_body',
			),
			'wacu_integration_settings'   => array(
				'facebook_customer_chat' => array(
					'status'           => 'no',
					'page_id'          => '',
					'background_color' => '#0084ff',
				),
				'tawk_to' => array(
					'status'      => 'no',
					'site_id'     => '',
					'widget_name' => '',
				),
				'wordpress_whatsapp_support' => array(
					'status'      => 'no',
				),
			),
			'wacu_grecaptcha_settings' => array(
				'v2_site_key'   => '',
				'v2_secret_key' => '',
			),
		) );
	}

	/**
	 * Get plugin options saved by the admin.
	 *
	 * @return array
	 */
	public static function admin_options() {
		$settings = array();

		foreach ( self::default_options() as $name => $value ) {
			if ( ! get_option( $name ) ) {
				continue;
			}

			$settings[$name] = get_option( $name );
		}

		return $settings;
	}

	/**
	 * Array merge recursive.
	 *
	 * @param array $args
	 * @param array $defaults
	 *
	 * @return array
	 */
	public static function parse_args_r( &$args, $defaults ) {
		$a      = (array) $args;
		$b      = (array) $defaults;
		$result = $b;
		foreach ( $a as $k => &$v ) {
			if ( is_array( $v ) && isset( $result[$k] ) ) {
				$result[$k] = self::parse_args_r( $v, $result[$k] );
			} else {
				$result[$k] = $v;
			}
		}
		return $result;
	}
}
