<?php
defined( 'ABSPATH' ) || exit;

class WACU_Integration_Tawk_To {

	public function __construct() {
		if ( ! wacu_is_widget_display() ) {
			return;
		}
		if ( 'yes' !== wacu_integration_option( 'tawk_to', 'status' ) ) {
			return;
		}

		add_action( 'wp_footer', array( $this, 'output' ), 60 );
		add_action( 'wp_enqueue_scripts', array( $this, 'inline_css' ), 240 );
	}

	public function output() {
		$site_id     = wacu_integration_option( 'tawk_to', 'site_id' );
		$widget_name = wacu_integration_option( 'tawk_to', 'widget_name' );
		?>
		<!--WACU: Start of Tawk.to Script-->
		<script type="text/javascript">
			var Tawk_API = Tawk_API || {}, Tawk_LoadStart = new Date();

			( function( $ ) {
				var s1 = document.createElement( "script" ),
					s0 = document.getElementsByTagName( "script" )[0];

				s1.async = true;
				s1.src = "https://embed.tawk.to/<?php echo esc_html( $site_id ); ?>/<?php echo esc_html( $widget_name ); ?>";
				s1.charset = 'UTF-8';
				s1.setAttribute( 'crossorigin','*' );
				s0.parentNode.insertBefore( s1, s0 );

				Tawk_API.onChatHidden = function() {
					$( '.wacu-widget' ).show();
				};

				Tawk_API.onChatEnded = function(){
					$( '.wacu-widget' ).show();
				};

				Tawk_API.onLoad = function(){
					Tawk_API.minimize();
				};

				Tawk_API.onChatMinimized = function(){
					$( '.wacu-widget' ).show();
				};

				$( document ).ready( function() {

					$( document ).on( 'click', '[data-wacu-integration-trigger="tawk_to"]', function( e ) {
						if ( ! wacuGDPR.isChecked() ) {
							e.preventDefault();
							wacuGDPR.showError();
						} else {
							Tawk_API.maximize();
							$( '.wacu-widget' ).hide();
						}

					} );

				} );

			} )( jQuery );
		</script>
		<!--WACU: End of Tawk.to Script-->
		<?php
	}

	public function inline_css() {
		$trigger_offset_x = wacu_appearance_option( 'trigger_offset_x' );
		$trigger_offset_y = wacu_appearance_option( 'trigger_offset_y' );
		$widget_location  = wacu_appearance_option( 'widget_location' );

		$css = '';

		wp_add_inline_style( 'wacu-style', $css );
	}

}

function wacu_integration_tawk_to() {
	new WACU_Integration_Tawk_To;
}
add_action( 'wp', 'wacu_integration_tawk_to' );
