<?php
defined( 'ABSPATH' ) || exit;

function wacu_is_woocommerce() {
	return class_exists( 'WooCommerce' );
}

function wacu_widget_classes() {
	$classes = array();
	$classes = apply_filters( __FUNCTION__, $classes );
	echo join( ' ', $classes );
}

function wacu_is_widget_display() {
	// Check the widget visiablitiy.
	if ( 'yes' !== wacu_basic_setting_option( 'widget_status' ) ) {
		return false;
	}
	// Check register user accessibility
	if ( ! is_user_logged_in() && 'yes' === wacu_basic_setting_option( 'filter_by_regester_user' ) ) {
		return false;
	}
	// Check devices accessibility
	if ( wp_is_mobile() && 'yes' !== wacu_basic_setting_option( 'display_on_mobile' ) ) {
		return false;
	}
	if ( ! wp_is_mobile() && 'yes' !== wacu_basic_setting_option( 'display_on_desktop' ) ) {
		return false;
	}
	// Check page accessibility
	if ( 'no' === wacu_basic_setting_option( 'filter_by_everywhere' ) ) {
		if ( ! in_array( get_the_ID(), wacu_basic_setting_option( 'filter_include_by_page' ) ) ) {
			return false;
		}
	}

	return true;
}

function wacu_get_option( $option, $section, $default = '' ) {
	$options = get_option( $section );

	if ( isset( $options[$option] ) ) {
		return $options[$option];
	}

	return $default;
}

function wacu_appearance_option( $option, $default = '' ) {
	return wacu_get_option( $option, 'wacu_appearance_settings', $default );
}

function wacu_basic_setting_option( $option, $default = '' ) {
	return wacu_get_option( $option, 'wacu_basic_settings', $default );
}

function wacu_email_us_option( $option, $default = '' ) {
	return wacu_get_option( $option, 'wacu_email_us_settings', $default );
}

function wacu_schedule_call_option( $option, $default = '' ) {
	return wacu_get_option( $option, 'wacu_schedule_call_settings', $default );
}

function wacu_gdpr_option( $option, $default = '' ) {
	return wacu_get_option( $option, 'wacu_gdpr_settings', $default );
}

function wacu_smart_popup_option( $option, $default = '' ) {
	return wacu_get_option( $option, 'wacu_smart_popup_settings', $default );
}

function wacu_text_option( $option, $default = '' ) {
	return wacu_get_option( $option, 'wacu_text_settings', $default );
}

function wacu_grecaptcha_option( $option, $default = '' ) {
	return wacu_get_option( $option, 'wacu_grecaptcha_settings', $default );
}

function wacu_integration_option( $integration, $option, $default = '' ) {
	$opt = get_option( 'wacu_integration_settings', $default );

	if ( ! isset( $opt[$integration][$option] ) ) {
		return $default;
	}

	return $opt[$integration][$option];
}

function wacu_template_variables( $subject ) {
	$search = array(
		'{{title}}',
		'{{current_url}}',
		'{{page_title}}',
		'{{page_url}}',
	);
	$replace = array(
		get_the_title(),
		get_permalink(),
		get_the_title(),
		get_permalink(),
	);

	$replaced_subject = str_replace( $search, $replace, $subject );

	return apply_filters( 'wacu_template_variables', $replaced_subject, $search, $replace, $subject );
}

/**
 * Convert HEX to RGB.
 *
 * @param string $color
 *
 * @since 1.1.4
 * @return array
 *
 */
function wacu_hex2rgb( $color ) {
	$color = trim( $color, '#' );

	if ( strlen( $color ) == 3 ) {
		$r = hexdec( substr( $color, 0, 1 ) . substr( $color, 0, 1 ) );
		$g = hexdec( substr( $color, 1, 1 ) . substr( $color, 1, 1 ) );
		$b = hexdec( substr( $color, 2, 1 ) . substr( $color, 2, 1 ) );
	} elseif ( strlen( $color ) == 6 ) {
		$r = hexdec( substr( $color, 0, 2 ) );
		$g = hexdec( substr( $color, 2, 2 ) );
		$b = hexdec( substr( $color, 4, 2 ) );
	} else {
		return array();
	}

	return array(
		'red'   => $r,
		'green' => $g,
		'blue'  => $b,
	);
}

/**
 * Convert HEX to RGBA.
 *
 * @param string    $color
 * @param int|float $alpha
 *
 * @since 1.1.4
 * @return array
 *
 */
function wacu_hex2rgba( $color, $alpha ) {
	$rgba = array_merge( wacu_hex2rgb( $color ), array( 'alpha' => $alpha ) );

	return $rgba;
}

/**
 * Get current time.
 *
 * @since 1.2.1
 *
 * @param string $format Format for time.
 */
function wacu_get_current_time( $format = 'M d, Y H:i:s' ) {
	return current_time( apply_filters( 'wacu_current_time_format', $format ) );
}
