<?php
defined( 'ABSPATH' ) || exit;

function wacu_get_social_contacts() {
	global $wpdb;

	$social_contacts           = array();

	if ( ! get_transient( 'wacu_social_contacts' ) ) {

		$query = new WP_Query( array(
			'post_type'      => 'wacu_social_contact',
			'posts_per_page' => -1,
			'order'          => 'ASC',
			'orderby'        => 'meta_value_num',
			'meta_key'       => 'position'
		) );

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) { $query->the_post();
				$id = get_the_ID();

				$social_contacts[ $id ] = array(
					'id'            => absint( $id ),
					'icon'          => get_post_meta( $id, 'icon', true ),
					'icon_color'    => get_post_meta( $id, 'icon_color', true ),
					'type'          => get_post_meta( $id, 'type', true ),
					'device'        => get_post_meta( $id, 'device', true ),
					'target'        => get_post_meta( $id, 'target', true ),
					'link'          => get_post_meta( $id, 'link', true ),
					'title'         => get_the_title(),
					'description'   => get_the_content(),
					'content'       => get_post_meta( $id, 'content', true ),
					'status'        => get_post_meta( $id, 'status', true ),
					'register_only' => get_post_meta( $id, 'register_only', true ),
					'integration'   => get_post_meta( $id, 'integration', true ),
					'position'      => get_post_meta( $id, 'position', true ),
				);
			}
		}

		wp_reset_postdata();

		set_transient( 'wacu_social_contacts', $social_contacts, DAY_IN_SECONDS );
	}

	/**
	 * Filter social contacts.
	 *
	 * @since 2.0.0
	 *
	 * @param array $transient_social_contacts Social contacts from transient.
	 */
	return apply_filters( 'wacu_social_contacts', get_transient( 'wacu_social_contacts' ) );
}

function wacu_get_social_contact( $id, $data = '' ) {
	$social_contacts = wacu_get_social_contacts();

	if ( $data ) {
		if ( isset( $social_contacts[$id][$data] ) ) {
			return $social_contacts[$id][$data];
		}
	} if ( $id ) {
		if ( isset( $social_contacts[$id] ) ) {
			return $social_contacts[$id];
		}
	} else {
		return false;
	}
}

/**
 * Get available or activate social contacts.
 *
 * @since 2.0.0
 *
 * @return array
 */
function wacu_get_available_social_contacts() {
	$available_social_contacts = array();

	foreach ( wacu_get_social_contacts() as $social_contact ) {
		if ( 0 == $social_contact['status'] ) {
			continue;
		}
		if ( 1 == $social_contact['register_only'] && ! is_user_logged_in() ) {
			continue;
		}
		if ( 0 == $social_contact['device'] ) {
			continue;
		}
		if ( 1 == $social_contact['device'] && ! wp_is_mobile() ) {
			continue;
		}
		if ( 2 == $social_contact['device'] && wp_is_mobile() ) {
			continue;
		}

		$available_social_contacts[ $social_contact['id'] ] = $social_contact;
	}

	return $available_social_contacts;
}
