<?php defined( 'ABSPATH' ) || exit;?>
<div class="wacu-schedule-call">
	<form class="wacu-schedule-call-form" action="#" method="post">
		<?php wp_nonce_field( 'wacu_schedule_call_submit', 'wacu_schedule_call_security' );?>
		<input type="hidden" name="page_title" value="<?php the_title(); ?>">
		<input type="hidden" name="page_url" value="<?php the_permalink(); ?>">

		<div class="wacu-schedule-call__item">
			<div class="wacu-schedule-call__label">
				<label for=""><?php echo esc_html( wacu_schedule_call_option( 'label_full_name' ) ); ?></label>
			</div>
			<div class="wacu-schedule-call__input-type">
				<input type="text" name="wacu_schedule_call_name" data-wacu-schedule-call-required="1">
			</div>
		</div>
		<?php if ( 'yes' === wacu_schedule_call_option( 'field_country' ) ): ?>
			<div class="wacu-schedule-call__item">
				<div class="wacu-schedule-call__label">
					<label for=""><?php echo esc_html( wacu_schedule_call_option( 'label_country' ) ); ?></label>
				</div>
				<div class="wacu-schedule-call__input-type">
					<?php
						wacu_countries_dropdown( array(
							'name' => 'wacu_schedule_call_country',
						) );
					?>
				</div>
			</div>
		<?php endif;?>
		<div class="wacu-schedule-call__item">
			<div class="wacu-schedule-call__label">
				<label for=""><?php echo esc_html( wacu_schedule_call_option( 'label_callback_number' ) ); ?></label>
			</div>
			<div class="wacu-schedule-call__input-type">
				<input type="text" name="wacu_schedule_call_number" data-wacu-schedule-call-required="1">
			</div>
		</div>
		<?php if ( 'yes' === wacu_schedule_call_option( 'field_schedule_time' ) ): ?>
		<div class="wacu-schedule-call__item">
			<div class="wacu-schedule-call__label">
				<label for=""><?php echo esc_html( wacu_schedule_call_option( 'label_schedule_time' ) ); ?></label>
			</div>
			<div class="wacu-schedule-call__input-type">
				<div class="wacu-schedule-call-time-selector">
					<?php
						wacu_month_dropdown( array(
							'inline_css' => 'width: 40% !important;',
							'selected'   => date( 'F' ),
							'name'       => 'wacu_schedule_call_month',
						) );
						wacu_date_dropdown( array(
							'inline_css' => 'width: 30% !important;',
							'selected'   => date( 'd' ),
							'name'       => 'wacu_schedule_call_date',
						) );
						wacu_time_dropdown( array(
							'inline_css' => 'width: 30% !important;',
							'selected'   => '10:00',
							'name'       => 'wacu_schedule_call_time',
						) );
					?>
				</div>
			</div>
		</div>
		<?php endif;?>
		<?php if ( 'yes' === wacu_schedule_call_option( 'field_message' ) ): ?>
			<div class="wacu-schedule-call__item">
				<div class="wacu-schedule-call__label">
					<label for=""><?php echo esc_html( wacu_schedule_call_option( 'label_message' ) ); ?></label>
				</div>
				<div class="wacu-schedule-call__input-type">
					<textarea name="wacu_schedule_call_message"></textarea>
				</div>
			</div>
		<?php endif;?>

		<?php if ( 'yes' === wacu_schedule_call_option( 'grecaptcha' ) ) : ?>
		<div class="wacu-schedule-call__item">
			<div id="wacu-grecaptcha-v2-schedule-call" style="transform:scale(0.95);transform-origin:0 0;width:305px;"></div>
		</div>
		<?php endif; ?>

		<div>
			<input type="submit" value="<?php echo esc_attr( wacu_schedule_call_option( 'label_button' ) ); ?>">
		</div>
	</form>
	<div class="wacu-schedule-call-loader wacu-hide">
		<div class="wacu-spinner">
			<div class="double-bounce1 wacu-bg-color"></div>
			<div class="double-bounce2 wacu-bg-color"></div>
		</div>
	</div>
	<div class="wacu-schedule-call-response wacu-hide">
	</div>
</div>
