<?php defined( 'ABSPATH' ) || exit; ?>
<div class="wacu-widget <?php wacu_widget_classes(); ?>">
	<div class="wacu-widget__body">
		<div class="wacu-popup wacu-hide" data-wacu-main-popup-status="0">
			<div class="wacu-popup__header">
				<div class="wacu-popup__header-text"><?php echo esc_attr( wacu_text_option( 'header_text' ) ); ?></div>
				<div class="wacu-popup__header-cta" data-wacu-popup-trigger><?php echo WACU_Icon::get( 'close' ); ?></div>
			</div>
			<div class="wacu-popup__body">
				<?php do_action( 'wacu_before_popup_body' ); ?>
				<ul class="wacu-social-contacts">
					<?php if ( wacu_get_available_social_contacts() ) : ?>
						<?php
							foreach ( wacu_get_available_social_contacts() as $sc ) :

								$link   = '';
								$target = ( '_blank' == $sc['target'] ) ? '_blank' : '_self';
								$type_condition = '';

								if ( '1' === $sc['type'] ) {
									$link =  wp_kses_post( wacu_template_variables( $sc['link'] ) );
								}
								if ( '2' === $sc['type'] ) {
									$link = 'javascript:;';
									$type_condition = 'data-wacu-sub-popup-trigger="' . absint( $sc['id'] ) . '"';
								}
								if ( '3' === $sc['type'] ) {
									$link = 'javascript:;';
									$type_condition = 'data-wacu-integration-trigger="' . esc_attr( $sc['integration'] ) . '"';
								}
						?>
								<li class="wacu-social-contact" <?php echo $type_condition // WPCS: XSS. ok ?>>

									<?php
									/**
									 * Hook: Before social contact link.
									 *
									 * @since 2.0.0
									 *
									 * @param array $sc Social contact array.
									 */
									do_action( 'wacu_before_social_contact_link', $sc );
									?>

									<a href="<?php echo $link; // WPCS. XSS. ok ?>" target="<?php echo esc_attr( $target ); ?>">
										<div class="wacu-social-contact__icon" style="color: <?php echo esc_attr( $sc['icon_color'] ); ?>;">
											<?php if ( $icon = WACU_Icon::get( $sc['icon'] ) ): ?>
												<?php echo $icon; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
											<?php else: ?>
												<?php echo wp_kses_post( $sc['icon'] ); ?>
											<?php endif; ?>
										</div>
										<div class="wacu-social-contact__detail">
											<div class="wacu-social-contact__name"><?php echo esc_html( $sc['title'] ); ?></div>
											<div class="wacu-social-contact__desc"><?php echo esc_html( $sc['description'] ); ?></div>
										</div>
									</a>
								</li>
						<?php
							endforeach;
						?>
					<?php endif; ?>
				</ul>
				<?php do_action( 'wacu_after_popup_body' ); ?>
			</div>
		</div>
		<?php if ( wacu_get_social_contacts() ) : ?>
			<?php foreach ( wacu_get_social_contacts() as $sc ) : ?>
				<?php if ( '2' === $sc['type'] ) : ?>
					<div class="wacu-sub-popup wacu-hide" data-wacu-sub-popup="<?php echo intval( $sc['id'] ); ?>">
						<div class="wacu-sub-popup__header">
							<div class="wacu-sub-popup__header-text"><?php echo esc_html( $sc['title'] ); ?></div>
							<div class="wacu-sub-popup__header-cta" data-wacu-main-popup><?php echo WACU_Icon::get( 'close' ); ?></div>
						</div>
						<div class="wacu-sub-popup__body">
							<?php echo do_shortcode( $sc['content'] ); ?>
						</div>
					</div>
				<?php endif; ?>
			<?php endforeach; ?>
		<?php endif; ?>
		<?php if ( wacu_get_smart_messages() && 'yes' === wacu_smart_popup_option( 'status' ) ) : ?>
			<div class="wacu-smart-popup">
				<div class="wacu-smart-popup-cta" data-wacu-smart-popup-close><?php echo WACU_Icon::get( 'close' ); ?></div>
				<div class="wacu-smart-popup-messages">
					<div class="wacu-typing">
						<div class="wacu-typing-bounce1"></div>
						<div class="wacu-typing-bounce2"></div>
						<div class="wacu-typing-bounce3"></div>
					</div>
					<?php foreach( wacu_get_smart_messages() as $sm ) : ?>
						<?php
							if ( 0 == $sm['status'] ) {
								continue;
							}
							if ( '0' !== $sm['post_type'] ) {
								if ( $sm['post_type'] !== get_post_type() ) {
									continue;
								}
							}
						?>
						<div class="wacu-smart-popup-message_item wacu-hide">
							<?php echo wp_kses_post( wpautop( wacu_template_variables( $sm['message'] ) ) ); ?>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
	<div class="wacu-widget__footer">

		<?php if ( 'icon_only' !== wacu_appearance_option( 'trigger_type' ) ) : ?>

			<?php require_once WACU_PLUGIN_PATH . '/templates/triggers/icon-with-text.php'; ?>

		<?php else : ?>

			<?php require_once WACU_PLUGIN_PATH . '/templates/triggers/icon-only.php'; ?>

		<?php endif; ?>

	</div>
</div>
